-- overwriting null values to empty string
UPDATE `products_item_codes` SET `code_isbn` = '' WHERE `products_item_codes`.`code_isbn` IS NULL;
UPDATE `products_item_codes` SET `code_upc` = '' WHERE `products_item_codes`.`code_upc` IS NULL;
UPDATE `products_item_codes` SET `code_mpn` = '' WHERE `products_item_codes`.`code_mpn` IS NULL;
UPDATE `products_item_codes` SET `code_jan` = '' WHERE `products_item_codes`.`code_jan` IS NULL;
-- changing code columns to not allow null values
ALTER TABLE `products_item_codes` CHANGE `code_isbn` `code_isbn` VARCHAR(128) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '\'\'';
ALTER TABLE `products_item_codes` CHANGE `code_upc` `code_upc` VARCHAR(128) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '\'\'';
ALTER TABLE `products_item_codes` CHANGE `code_mpn` `code_mpn` VARCHAR(128) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '\'\'';
ALTER TABLE `products_item_codes` CHANGE `code_jan` `code_jan` VARCHAR(128) CHARACTER SET utf8mb3 COLLATE utf8_general_ci NOT NULL DEFAULT '\'\'';
-- add missing entries
INSERT INTO `products_item_codes` (
   `products_id`,
    `code_isbn`,
    `code_upc`,
    `code_mpn`,
    `code_jan`,
    `google_export_condition_id`,
    `google_export_availability_id`,
    `brand_name`,
    `identifier_exists`,
    `gender`,
    `age_group`
)  SELECT
    `p`.`products_id`,
    '' AS 'code_isbn',
    '' AS 'code_upc',
    '' AS 'code_mpn',
    '' AS 'code_jan',
    1  AS 'google_export_condition_id',
    0  AS 'google_export_availability_id',
    '' AS 'brand_name',
    0  AS 'identifier_exists',
    '' AS 'gender',
    '' AS 'age_group'
FROM `products_item_codes` AS pic
         RIGHT JOIN `products` AS p ON `pic`.`products_id` = `p`.`products_id`
WHERE `pic`.`products_id` IS NULL;